<?php

/**
 * Class that operate on table 'goverarea'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-12-29 21:43
 */
class GoverareaMySqlDAO implements GoverareaDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return GoverareaMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM goverarea WHERE goverareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM goverarea';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM goverarea ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param goverarea primary key
     */
    public function delete($goverareaid) {
        $sql = 'DELETE FROM goverarea WHERE goverareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($goverareaid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param GoverareaMySql goverarea
     */
    public function insert($goverarea) {
        $sql = 'INSERT INTO goverarea (governmentid, clientareaid) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($goverarea->governmentid);
        $sqlQuery->setNumber($goverarea->clientareaid);

        $id = $this->executeInsert($sqlQuery);
        $goverarea->goverareaid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param GoverareaMySql goverarea
     */
    public function update($goverarea) {
        $sql = 'UPDATE goverarea SET governmentid = ?, clientareaid = ? WHERE goverareaid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($goverarea->governmentid);
        $sqlQuery->setNumber($goverarea->clientareaid);

        $sqlQuery->setNumber($goverarea->goverareaid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM goverarea';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByGovernmentid($value) {
        $sql = 'SELECT * FROM goverarea WHERE governmentid = ?';

        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);

        return $this->getList($sqlQuery);
    }

    public function queryByClientareaid($value) {
        $sql = 'SELECT * FROM goverarea WHERE clientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByGovernmentid($value) {
        $sql = 'DELETE FROM goverarea WHERE governmentid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientareaid($value) {
        $sql = 'DELETE FROM goverarea WHERE clientareaid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return GoverareaMySql
     */
    protected function readRow($row) {
        $goverarea = new Goverarea();

        $goverarea->goverareaid = isset($row['goverareaid']) ? $row['goverareaid'] : '';
        $goverarea->governmentid = isset($row['governmentid']) ? $row['governmentid'] : '';
        $goverarea->clientareaid = isset($row['clientareaid']) ? $row['clientareaid'] : '';

        return $goverarea;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return GoverareaMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>